﻿Imports System.Runtime.CompilerServices

Module ExtensionMethods

    <Extension()>
    Public Function Clone(ByVal texture As Texture2D) As Texture2D
        Using ms As New IO.MemoryStream
            texture.SaveAsPng(ms, texture.Width, texture.Height)
            ms.Position = 0
            Return Texture2D.FromStream(texture.GraphicsDevice, ms)
        End Using
    End Function

    <Extension()>
    Public Function ToImage(ByVal texture As Texture2D) As Drawing.Bitmap
        Using ms As New IO.MemoryStream
            texture.SaveAsPng(ms, texture.Width, texture.Height)
            ms.Position = 0
            Return New Drawing.Bitmap(ms)
        End Using
    End Function


End Module
